%% Plot Delft Model
vmax = 2.7045;                           %velocità massima MiR

Fc_pos=@(x,y) (((x-y)/abs(x+1/cccc))*(((x-y)/abs(x+1/cccc))<=1 )+ 1*(((x-y)/abs(x+1/cccc))>1))*(x*y>=0 && x>=0) + (((x-y)/abs(y+1/cccc))*(((x-y)/abs(y+1/cccc))<=1 ))*(x*y>0 && x<0)+ (x*y<0)*(x/abs(x+1/cccc));

Fc_neg=@(x,y) (((x-y)/abs(y+1/cccc))*(((x-y)/abs(y+1/cccc))>=-1)+ (-1)*(((x-y)/abs(y+1/cccc))<-1))*(x*y>=0 && y>=0) + (((x-y)/abs(x+1/cccc))*(((x-y)/abs(x+1/cccc))>=-1))*(x*y>0 && y<0) + (x*y<0)*(x/abs(x+1/cccc)) ; 

x=linspace(-vmax,vmax,100)';
y=linspace(-vmax,vmax,100)';

Fc_pos_sol=ones(100,100);

Fc_neg_sol=ones(100,100);

for ii=1:100
for jj=1:100

    Fc_pos_sol(ii,jj)=Fc_pos(x(ii,1),y(jj,1));

    Fc_neg_sol(ii,jj)=Fc_neg(x(ii,1),y(jj,1));
end
end

Fc_sol=zeros(100,100);
Fc_sol_NL= (Fc_pos_sol>=0).*Fc_pos_sol + (Fc_pos_sol<0).*Fc_neg_sol + Fc_sol;

figure
surf(y,x,Fc_sol_NL)
%shading interp
ylabel('\omega_R*r [m/s]')
xlabel('V_O_,_x [m/s]')
zlabel('Slip factor')
title('Modello di Delft')
%% Plot Delft Modificato 
vmax = 2.7045;


Fc_pos=@(x,y) ((((x-y)/abs(x+1/cccc))*(((x-y)/abs(x+1/cccc))<=1 )+ 1*(((x-y)/abs(x+1/cccc))>1))*(x*y>=0 && x>=0) + (((x-y)/abs(y+1/cccc))*(((x-y)/abs(y+1/cccc))<=1 ))*(x*y>0 && x<0)+ (x*y<0)*(x/abs(x+1/cccc)))*(0.02<(x^2+y^2)) + (10*(x-y)*(10*(x-y)<1) +1*(10*(x-y)>=1))*(0.02>=(x^2+y^2));

Fc_neg=@(x,y) ((((x-y)/abs(y+1/cccc))*(((x-y)/abs(y+1/cccc))>=-1)+ (-1)*(((x-y)/abs(y+1/cccc))<-1))*(x*y>=0 && y>=0) + (((x-y)/abs(x+1/cccc))*(((x-y)/abs(x+1/cccc))>=-1))*(x*y>0 && y<0) + (x*y<0)*(x/abs(x+1/cccc)) )*(0.02<(x^2+y^2)) +(10*(x-y)*(10*(x-y)>-1) -1*(10*(x-y)<=-1))*(0.02>=(x^2+y^2)); 


x=linspace(-vmax,vmax,100)';
y=linspace(-vmax,vmax,100)';

Fc_pos_sol=ones(100,100);

Fc_neg_sol=ones(100,100);

for ii=1:100
for jj=1:100

    Fc_pos_sol(ii,jj)=Fc_pos(x(ii,1),y(jj,1));

    Fc_neg_sol(ii,jj)=Fc_neg(x(ii,1),y(jj,1));
end
end

Fc_sol=zeros(100,100);
Fc_sol_NL_MOD= (Fc_pos_sol>=0).*Fc_pos_sol + (Fc_pos_sol<0).*Fc_neg_sol + Fc_sol;

figure
surf(y,x,Fc_sol_NL_MOD)
%shading interp
ylabel('\omega_R*r [m/s]')
xlabel('V_O_,_x [m/s]')
zlabel('Slip factor')
title('Modello di Delft modificato')
%% Residual Delft-Delft mod

Residual=Fc_sol_NL-Fc_sol_NL_MOD;
figure
surf(y,x,Residual)
shading interp
ylabel('\omega_R*r [m/s]')
xlabel('V_O_,_x [m/s]')
zlabel('Residual')
title('Residual')